#ifndef _TEST_APP
#define _TEST_APP

#pragma once //
#include "ofMain.h"
#include "ofxOpenCv.h"
#include "cv.h"
#include "cvaux.h"
#include "ofxVectorMath.h"  // DRAWING & COLLISION
#include "ofxBox2d.h"       // BALLS & COLLISION
#include "ofxContourAnalysis.h" // COLLISION

//#define _USE_LIVE_VIDEO		// uncomment this to use a live camera
								// otherwise, we'll use a movie file

#define MAX_N_PTS         1500 // DRAWING

// BALLS
class MyContactListener : public b2ContactListener {
    public:
        void Add(const b2ContactPoint* point);
        void Remove(const b2ContactPoint* point);
};
// BALLS
class CustomBall : public ofxBox2dCircle {
    public:
        void update	();
        void draw	();
        int r;  int g;  int b;
};

// COLLISION
class CustomParticle : public ofxBox2dCircle {
public:

	float c; // the color
	CustomParticle() {
    }

	void draw() {
		float radius = getRadius();
		glPushMatrix();
		glTranslatef(getPosition().x, getPosition().y, 0);

		if(radius > 15) {
			ofSetColor(c, 255-c, c);
			ofFill();
			ofCircle(0, 0, radius);

			ofSetColor(c-255, c, c);
			ofFill();
			ofCircle(0, 0, radius/2.3);

			ofSetColor(255, 255, 255);
			ofFill();
			ofCircle(0, 0, 2);
		}
		else {
			//ofSetColor(250, c, 10);
			ofSetColor(c, 10, 250);
			ofFill();
			ofCircle(0, 0, radius);
		}
		glPopMatrix();
	}
};

class testApp : public ofBaseApp{
    public:

    void setup();
    void update();
    void draw();

    void keyPressed  (int key);
    void mouseMoved(int x, int y );
    void mouseDragged(int x, int y, int button);
    void mousePressed(int x, int y, int button);
    void mouseReleased(int x, int y, int button);
    void resized(int w, int h);

    // COLLISION
	ofxBox2d					box2dCollision;	  // the box2d world
	ofxBox2dLine				lineStrip;		  // a linestrip for contours
	vector <CustomParticle>		customParticles;  // this is a custom particle

	//bool					bDrawGray;
	float					simpleAmount;
	int						threshold;

	ofxCvColorImage			colorCollision;
	ofxCvGrayscaleImage		grayCollision;

	ofxCvContourFinder		contour;
	ofxContourAnalysis		contourAnalysis;
	vector <ofPoint>		simpleCountour;

    #ifdef _USE_LIVE_VIDEO
        ofVideoGrabber 		vidGrabber;
    #else
        ofVideoPlayer 		vidPlayer;
    #endif

    ofxCvColorImage			colorImg;///////////

    CvBGStatModel*          gauss_bgModel;
    ofxCvGrayscaleImage     gauss_foregroundImg;
    ofxCvColorImage         gauss_backgroundImg;

    ofxCvContourFinder      contourFinder;

    ofTrueTypeFont myFont;

    // PIXELS
    ofImage pic;
    int location;
    unsigned char * pixels;

    // DRAWING
    ofxVec3f	pts[MAX_N_PTS];
    int			nPts;
    bool		bDrawnAnything;

    // BALLS
    void box2dContactEventHandler	( const b2ContactPoint* point );
    ofxBox2d					box2d;
    vector<CustomBall>			balls;
    MyContactListener			contacts;

    // SAVE PMG IMAGES FOR VIDEO
    //ofImage img_saver;
	//int saved_image_num;
};

#endif
