/*
* ofxCvTrackedBlob.h
* openFrameworks
*
* This class represents a blob with inter-frame information.
* This includes a persistent id to assume a persistent identity over
* time.
*
*/


#ifndef OF_CV_TRACKEDBLOB_H
#define OF_CV_TRACKEDBLOB_H

#include "ofxOpenCv.h"
#include "ofxBox2d.h"
#include "ofxContourUtil.h"

class ofxCvTrackedBlob : public ofxCvBlob {
  public:

    int id;

    ofPoint deltaLoc;
    ofPoint deltaLocTotal;
    ofPoint predictedPos;
    float deltaArea;

    ofxBox2dLine	lineStrip;
    ofxContourUtil cu;

    // Used only by BlobTracker
    //
    bool markedForDeletion;
    int framesLeft;
    vector<float> error;
    vector<int> closest;  // ids of the closest points, sorted

    ofxCvTrackedBlob() {
        id = -1;
        area = 0.0f;
        length = 0.0f;
        deltaArea = 0.0f;
        markedForDeletion = false;
        framesLeft = 0;
    }

    ofxCvTrackedBlob( const ofxCvBlob& b ) {
        area = b.area;
        length = b.length;
        boundingRect = b.boundingRect;
        centroid = b.centroid;
        hole = b.hole;
        pts = b.pts;
        nPts = b.nPts;

        id = -1;
        deltaArea = 0.0f;
        markedForDeletion = false;
        framesLeft = 0;
    }

    int getLowestError() {
        int best=-1;
        float best_v=99999.0f;
        for( unsigned int i=0; i<error.size(); i++ ) {
            if( error[i] < best_v ) {
                best = i;
                best_v = error[i];
            }
        }
        return best;
    }

    void drawLine(){
        ofBeginShape();
        for (int i = 0; i < nPts; i++){
               ofVertex(pts[i].x, pts[i].y);
        }
        ofEndShape(true);
    }

    void drawStrip(b2World* theworld, float simplify, int col){
        //lineStrip.clear();
        int r = (col >> 16) & 0xff;
        int g = (col >> 8) & 0xff;
        int b = (col >> 0) & 0xff;
        vector <ofPoint>   simple;
        cu.simplify(pts, simple, simplify);

        lineStrip.setWorld(theworld);
        for (int i = simple.size()-1; i>=0; i--){
            lineStrip.addPoint(simple[i].x, simple[i].y);
        }

        lineStrip.r = r;
        lineStrip.g = g;
        lineStrip.b = b;
        //lineStrip.alpha = alpha;

        lineStrip.createShape();

        lineStrip.draw();
    }

    void drawRect(){
        ofRect(boundingRect.x, boundingRect.y, boundingRect.width, boundingRect.height);
    }
};


#endif


