#ifndef _TEST_APP
#define _TEST_APP

#pragma once //
#include "ofMain.h"
#include "ofxOpenCv.h"
#include "cv.h"
#include "cvaux.h"
#include "ofxVectorMath.h"  // DRAWING & COLLISION & TRAILS
#include "ofxBox2d.h"       // BALLS & COLLISION & TRAILS
#include "ofxContourUtil.h" // COLLISION & TRAILS
#include "ofxCvBlobTracker.h" // TRAILS

//#define _USE_LIVE_VIDEO		// uncomment this to use a live camera
								// otherwise, we'll use a movie file

#define MAX_N_PTS         1500 // DRAWING


// COLLISION
class CustomParticle : public ofxBox2dCircle {
public:

	float c; // color
	CustomParticle() {
    }

	void draw() {
		float radius = getRadius();
		glPushMatrix();
		glTranslatef(getPosition().x, getPosition().y, 0);

		if(radius > 15) {
			ofSetColor(c, 255-c, c);
			ofFill();
			ofCircle(0, 0, radius);

			ofSetColor(c-255, c, c);
			ofFill();
			ofCircle(0, 0, radius/2.3);

			ofSetColor(255, 255, 255);
			ofFill();
			ofCircle(0, 0, 2);
		}
		else {
			ofSetColor(c, 10, 250);
			ofFill();
			ofCircle(0, 0, radius);
		}
		glPopMatrix();
	}
};

class testApp : public ofBaseApp, public ofxCvBlobListener{
    public:

    void setup();
    void update();
    void draw();

    void keyPressed  (int key);
    void mouseMoved(int x, int y );
    void mouseDragged(int x, int y, int button);
    void mousePressed(int x, int y, int button);
    void mouseReleased(int x, int y, int button);
    void resized(int w, int h);
    void blobOn( int x, int y, int id, int order );
    void blobMoved( int x, int y, int id, int order );
    void blobOff( int x, int y, int id, int order );

    // COLLISION
	ofxBox2d					box2dCollision;
	vector <CustomParticle>		customParticles;

	float					simpleAmount;
	int						threshold;
	int                     blurb;

	ofxCvColorImage			colorCollision;

	ofxContourUtil		    contourUtil;
	vector <ofPoint>		simpleContour;

    #ifdef _USE_LIVE_VIDEO
        ofVideoGrabber 		vidGrabber;
    #else
        ofVideoPlayer 		vidPlayer;
    #endif

    ofxCvColorImage			colorImg;

    CvBGStatModel*          gauss_bgModel;
    ofxCvGrayscaleImage     gauss_foregroundImg;
    ofxCvColorImage         gauss_backgroundImg;

    ofxCvContourFinder      contourFinder;

    ofTrueTypeFont myFont;

    // DRAWING
    ofxVec3f	pts[MAX_N_PTS];
    int			nPts;
    bool		bDrawnAnything;
    vector <ofxBox2dLine>		drawingLine;

    // TRAILS
	ofxCvBlobTracker            bt;
};

#endif
