#ifndef OF_CV_TRACKEDBLOB_H
#define OF_CV_TRACKEDBLOB_H

#include "ofxOpenCv.h"

class ofxCvBlobListener {
public:
    virtual void blobOn(int x, int y, int id, int order) = 0;
    virtual void blobMoved(int x, int y, int id, int order) = 0;
    virtual void blobOff(int x, int y, int id, int order) = 0;
};

class ofxCvTrackedBlob: public ofxCvBlob {
public:
    int id;

    ofPoint deltaLoc;
    ofPoint deltaLocTotal;
    ofPoint predictedPos;
    float deltaArea;

    // Used only by BlobTracker
    bool markedForDeletion;
    int framesLeft;
    vector<float> error;
    vector<int> closest;  // ids of the closest points, sorted

    ofxCvTrackedBlob();
    ofxCvTrackedBlob(const ofxCvBlob& b);
    int getLowestError();
    void drawLine(bool withRect);
};

#endif
