#include "ofxBox2dBaseShape.h"

ofxBox2dBaseShape::ofxBox2dBaseShape() {
    m_world = NULL;
    m_body = NULL;

    r = 255;
    g = 255;
    b = 255;
    a = 255;
}

 ofxBox2dBaseShape::~ofxBox2dBaseShape() {
     destroyShape();
 }

void ofxBox2dBaseShape::destroyShape() {
    if (m_body) {
		m_world->DestroyBody(m_body);
		m_body = NULL;
	}
}

void ofxBox2dBaseShape::setColour(unsigned int hexColour) {
    r = (hexColour >> 16) & 0xff;
    g = (hexColour >>  8) & 0xff;
    b = (hexColour      ) & 0xff;
    a = hexColour > 0xffffff ? (hexColour >> 24) & 0xff : 0xff;
}

void ofxBox2dBaseShape::setColour(int _r, int _g, int _b, int _a) {
    r = _r;
    g = _g;
    b = _b;
    a = _a;
}
