#ifndef _TEST_APP
#define _TEST_APP

#include "ofMain.h"
#include "ofxOpenCv.h"
#include "ofxBox2d.h"
#include "ofxCvBlobTracker.h"
#include "ofxContourUtil.h"

//#define _USE_LIVE_VIDEO // Uncomment this if you want to use a live feed

class happyFace: public ofxBox2dCircle{
public:
    void draw();
};

class testApp: public ofBaseApp, public ofxCvBlobListener {

    ofxCvBlobTracker        blobTracker;

    ofxBox2d                box2d;
    b2World*                world;

    happyFace               circle;

    #ifdef _USE_LIVE_VIDEO
        ofVideoGrabber 		vidGrabber;
    #else
        ofVideoPlayer 		vidPlayer;
    #endif

    ofxCvColorImage		    colorImg;

    CvBGStatModel*          gauss_bgModel;
    ofxCvGrayscaleImage     gauss_foregroundImg;
    ofxCvColorImage         gauss_backgroundImg;

    ofxCvColorImage         scaleImg;

    ofxCvContourFinder 	    contourFinder;
    ofxContourUtil          contourUtil;

    int                     videoWidth;
    int                     videoHeight;
    int                     opWidth;
    int                     opHeight;
    int                     opScale;

    int 				    threshold;
    int                     blur;

public:
    void setup();
    void update();
    void draw();

    void keyPressed  (int key);
    void keyReleased(int key);

    void mouseMoved(int x, int y );
    void mouseDragged(int x, int y, int button);
    void mousePressed(int x, int y, int button);
    void mouseReleased(int x, int y, int button);

    void windowResized(int w, int h);

    void blobOn(int x, int y, int id, int order);
    void blobMoved(int x, int y, int id, int order);
    void blobOff(int x, int y, int id, int order);
};

#endif
